package gui;

import java.awt.EventQueue;

import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

import java.awt.BorderLayout;

import javax.swing.JTabbedPane;
import javax.swing.JButton;

import music.Author;
import music.Song;
import net.miginfocom.swing.MigLayout;
import util.Utility;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.SwingConstants;
import javax.swing.filechooser.FileNameExtensionFilter;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class NewDialog extends JDialog {
	private JPanel southPanel;
	private JTabbedPane tabbedPane;
	private JPanel songPanel;
	private JPanel authorPanel;
	private JButton btnOk;
	private JButton btnCancel;
	private JLabel lblTitle;
	private JLabel lblYear;
	private JLabel lblLyrics;
	private JTextField titleTextField;
	private JTextField yearTextField;
	private JScrollPane scrollPane;
	private JTextArea lyricsTextArea;
	
	private Song song;
	private NewDialog thisDialog;
	private JLabel lblName;
	private JLabel lblNationality;
	private JTextField nameTextField;
	private JLabel lblAge;
	private JTextField ageTextField;
	private JLabel lblGenre;
	private JTextField genreTextField;
	private JLabel lblPhoto;
	private JScrollPane imageScrollPane;
	private JLabel lblImage;
	private JTextField nationalityTextField;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					NewDialog dialog = new NewDialog();
					dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					dialog.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the dialog.
	 */
	public NewDialog() {
		setTitle("New");
		setBounds(100, 100, 450, 300);
		getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		getContentPane().add(getTabbedPane(), BorderLayout.CENTER);
	}

	public NewDialog(JFrame f, boolean modal) {
		setTitle("New");
		setBounds(100, 100, 450, 300);
		getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		getContentPane().add(getTabbedPane(), BorderLayout.CENTER);
		this.setModal(modal);
		thisDialog = this;
	}

	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.setLayout(new MigLayout("", "[grow][47px][65px]", "[23px]"));
			southPanel.add(getBtnOk(), "cell 1 0,alignx left,aligny top");
			southPanel.add(getBtnCancel(), "cell 2 0,alignx left,aligny top");
		}
		return southPanel;
	}
	private JTabbedPane getTabbedPane() {
		if (tabbedPane == null) {
			tabbedPane = new JTabbedPane(JTabbedPane.TOP);
			tabbedPane.addTab("Song", null, getSongPanel(), null);
			tabbedPane.addTab("Author", null, getAuthorPanel(), null);
		}
		return tabbedPane;
	}
	private JPanel getSongPanel() {
		if (songPanel == null) {
			songPanel = new JPanel();
			songPanel.setLayout(new MigLayout("", "[][grow]", "[][][][grow]"));
			songPanel.add(getLblTitle(), "cell 0 0,alignx left");
			songPanel.add(getTitleTextField(), "cell 1 0,growx");
			songPanel.add(getLblYear(), "cell 0 1,alignx left");
			songPanel.add(getYearTextField(), "cell 1 1,growx");
			songPanel.add(getLblLyrics(), "cell 0 2");
			songPanel.add(getScrollPane(), "cell 0 3 2 1,grow");
		}
		return songPanel;
	}
	private JPanel getAuthorPanel() {
		if (authorPanel == null) {
			authorPanel = new JPanel();
			authorPanel.setLayout(new MigLayout("", "[][grow][][grow]", "[][][][grow]"));
			authorPanel.add(getLblName(), "cell 0 0,alignx trailing");
			authorPanel.add(getNameTextField(), "cell 1 0,growx");
			authorPanel.add(getLblAge(), "cell 2 0,alignx trailing");
			authorPanel.add(getAgeTextField(), "cell 3 0,growx");
			authorPanel.add(getLblNationality(), "cell 0 1,alignx trailing");
			authorPanel.add(getNationalityTextField(), "cell 1 1,growx");
			authorPanel.add(getLblGenre(), "cell 2 1,alignx trailing");
			authorPanel.add(getGenreTextField(), "cell 3 1,growx");
			authorPanel.add(getLblPhoto(), "cell 0 2 4 1,alignx center");
			authorPanel.add(getImageScrollPane(), "cell 0 3 4 1,grow");
		}
		return authorPanel;
	}
	private JButton getBtnOk() {
		if (btnOk == null) {
			btnOk = new JButton("OK");
			btnOk.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					//					song = null;
					song = new Song();
					song.setTitle(titleTextField.getText());
					song.setYear(Integer.parseInt(yearTextField.getText()));
					song.setLyrics(lyricsTextArea.getText());
					Author author = new Author();
					author.setName(nameTextField.getText());
					author.setNationality(nationalityTextField.getText());
					author.setGenre(genreTextField.getText());
					author.setAge(Integer.parseInt(ageTextField.getText()));
					author.setImage(lblImage.getIcon());
					song.setAuthor(author);
					thisDialog.setVisible(false);
				}
			});
		}
		return btnOk;
	}
	private JButton getBtnCancel() {
		if (btnCancel == null) {
			btnCancel = new JButton("Cancel");
			btnCancel.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					song = null;
					thisDialog.setVisible(false);
				}
			});
		}
		return btnCancel;
	}
	private JLabel getLblTitle() {
		if (lblTitle == null) {
			lblTitle = new JLabel("Title");
		}
		return lblTitle;
	}
	private JLabel getLblYear() {
		if (lblYear == null) {
			lblYear = new JLabel("Year");
		}
		return lblYear;
	}
	private JLabel getLblLyrics() {
		if (lblLyrics == null) {
			lblLyrics = new JLabel("Lyrics");
		}
		return lblLyrics;
	}
	private JTextField getTitleTextField() {
		if (titleTextField == null) {
			titleTextField = new JTextField();
			titleTextField.setColumns(10);
		}
		return titleTextField;
	}
	private JTextField getYearTextField() {
		if (yearTextField == null) {
			yearTextField = new JTextField();
			yearTextField.setColumns(10);
		}
		return yearTextField;
	}
	private JScrollPane getScrollPane() {
		if (scrollPane == null) {
			scrollPane = new JScrollPane();
			scrollPane.setViewportView(getLyricsTextArea());
		}
		return scrollPane;
	}
	private JTextArea getLyricsTextArea() {
		if (lyricsTextArea == null) {
			lyricsTextArea = new JTextArea();
		}
		return lyricsTextArea;
	}
	
	public Song showDialog() {
		this.setVisible(true);
		dispose();
		return song;
	}
	private JLabel getLblName() {
		if (lblName == null) {
			lblName = new JLabel("Name");
		}
		return lblName;
	}
	private JLabel getLblNationality() {
		if (lblNationality == null) {
			lblNationality = new JLabel("Nationality");
		}
		return lblNationality;
	}
	private JTextField getNameTextField() {
		if (nameTextField == null) {
			nameTextField = new JTextField();
			nameTextField.setColumns(10);
		}
		return nameTextField;
	}
	private JLabel getLblAge() {
		if (lblAge == null) {
			lblAge = new JLabel("Age");
		}
		return lblAge;
	}
	private JTextField getAgeTextField() {
		if (ageTextField == null) {
			ageTextField = new JTextField();
			ageTextField.setColumns(10);
		}
		return ageTextField;
	}
	private JLabel getLblGenre() {
		if (lblGenre == null) {
			lblGenre = new JLabel("Genre");
		}
		return lblGenre;
	}
	private JTextField getGenreTextField() {
		if (genreTextField == null) {
			genreTextField = new JTextField();
			genreTextField.setColumns(10);
		}
		return genreTextField;
	}
	private JLabel getLblPhoto() {
		if (lblPhoto == null) {
			lblPhoto = new JLabel("Photo");
		}
		return lblPhoto;
	}
	private JScrollPane getImageScrollPane() {
		if (imageScrollPane == null) {
			imageScrollPane = new JScrollPane();
			imageScrollPane.setViewportView(getLblImage());
		}
		return imageScrollPane;
	}
	private JLabel getLblImage() {
		if (lblImage == null) {
			lblImage = new JLabel("");
			lblImage.addMouseListener(new MouseAdapter() {
				@Override
				public void mouseClicked(MouseEvent arg0) {
				    JFileChooser chooser = new JFileChooser();
				    FileNameExtensionFilter filter = new FileNameExtensionFilter(
				        "JPG & GIF Images", "jpg", "jpeg", "gif", "png");
				    chooser.setFileFilter(filter);
				    int returnVal = chooser.showOpenDialog(thisDialog);
				    if(returnVal == JFileChooser.APPROVE_OPTION) {
//				       System.out.println("You chose to open this file: " +
//				            chooser.getSelectedFile().getName());
						lblImage.setIcon(new ImageIcon(Utility.getResourcesDir() + chooser.getSelectedFile().getName()));
				    }
				}
			});
			lblImage.setHorizontalAlignment(SwingConstants.CENTER);
//			lblImage.setIcon(new ImageIcon("C:\\Documents and Settings\\student1.B009\\My Documents\\Like a Rolling Stone, 23.12.2015, 14-16, E\\resources\\Bob Dylan.jpg"));
//			lblImage.setIcon(new ImageIcon(Utility.getProjectDir() + "\\resources\\Bob Dylan.jpg"));
			lblImage.setIcon(new ImageIcon(Utility.getResourcesDir() + "Bob Dylan.jpg"));
		}
		return lblImage;
	}
	private JTextField getNationalityTextField() {
		if (nationalityTextField == null) {
			nationalityTextField = new JTextField();
			nationalityTextField.setColumns(10);
		}
		return nationalityTextField;
	}
}
